; corz gui window animation effects example
;
#include <Constants.au3>
#include <GuiConstants.au3>
#include <corz_gui_fx.au3>
AutoItSetOption("GUIOnEventMode", 1)
HotKeySet("{ESC}","DoQuit")

$show = true
$gui = GUICreate("My Animating GUI", 200, 80)
GUISetOnEvent($GUI_EVENT_CLOSE, "DoQuit", $gui)

AutoItSetOption("TrayMenuMode", 1)
AutoItSetOption("TrayOnEventMode", 1)

local $win_anims[11] = ["Slide Left", "Slide Top", "Slide Right", "Slide Bottom", _
						"Slide Top Left", "Slide Top Right", "Slide Bottom Right", "Slide Bottom Left", _
						"Explode/Implode", "Fade", "Disable"]

$label = GUICtrlCreateLabel("up/down arrow keys also work fine", 10, 36, 175)

$combo = GUICtrlCreateCombo("", 10, 10, 115, 20)
GUICtrlSetData(-1, "Slide Left|Slide Top|Slide Right|Slide Bottom|Slide Top Left|Slide Top Right|Slide Bottom Right|Slide Bottom Left|Explode/Implode|Fade|Disable")
GUICtrlSetOnEvent(-1, "ComboSetGuiAnim")

$button = GUICtrlCreateButton("do it!", 130, 10, 50, 20)
GUICtrlSetOnEvent(-1, "ComboSetGuiAnim")

; retrieve ini settings (if any), and use them to show the gui..
$my_fx = corz_GUIAnimateOpen($gui, "", "test.ini", "fx demo")

; set the combo box to the correct animation string..
GUICtrlSetData($combo, EnvGet('gui_fx'))

; make the tray menu..
global $menu_items_win_anim[11]
for $i = 0 to 10
	$menu_items_win_anim[$i] = TrayCreateItem($win_anims[$i], -1, -1, 1) ;radio menu items
	TrayItemSetOnEvent(-1, "TraySetGuiAnim")
next
for $i in $menu_items_win_anim ; set initial checked status
	if TrayItemGetText($i) = EnvGet('gui_fx') then TrayItemSetState($i, $TRAY_CHECKED)
next
TraySetState()

do ; idle loop..
	Sleep(333)
until not $show

corz_GUIAnimateClose($gui, $my_fx)

; fin

func ComboSetGuiAnim()
	$my_fx = corz_GUIAnimateClose($gui, GUICtrlRead($combo), "test.ini", "fx demo")
	Sleep(333)
	for $i in $menu_items_win_anim
		if TrayItemGetText($i) = EnvGet('gui_fx') then 
			TrayItemSetState($i, $TRAY_CHECKED)
		else
			TrayItemSetState($i, $TRAY_UNCHECKED)
		endif
	next
	corz_GUIAnimateOpen($gui, $my_fx)
endfunc

func TraySetGuiAnim() 
	$my_fx = corz_GUIAnimateClose($gui, TrayItemGetText(@TRAY_ID), "test.ini", "fx demo")
	Sleep(333)
	corz_GUIAnimateOpen($gui, $my_fx)
	Sleep(250)
	GUICtrlSetData($combo, EnvGet('gui_fx')); or TrayItemGetText(@TRAY_ID)
endfunc

; bye!
func DoQuit()
	$show = false
endfunc
